### 28.1.2. 连接到一个生产环境数据库

在生产环境中，数据库连接可以使用DataSource池进行自动配置。下面是选取一个特定实现的算法：

- 由于Tomcat数据源连接池的性能和并发，在tomcat可用时，我们总是优先使用它。
- 如果HikariCP可用，我们将使用它。
- 如果Commons DBCP可用，我们将使用它，但在生产环境不推荐使用它。
- 最后，如果Commons DBCP2可用，我们将使用它。

如果你使用spring-boot-starter-jdbc或spring-boot-starter-data-jpa 'starter POMs'，你将会自动获取对tomcat-jdbc的依赖。

**注**：其他的连接池可以手动配置。如果你定义自己的DataSource bean，自动配置不会发生。

DataSource配置通过外部配置文件的spring.datasource.*属性控制。示例中，你可能会在application.properties中声明下面的片段：
```java
spring.datasource.url=jdbc:mysql://localhost/test
spring.datasource.username=dbuser
spring.datasource.password=dbpass
spring.datasource.driver-class-name=com.mysql.jdbc.Driver
```
其他可选的配置可以查看[DataSourceProperties](http://github.com/spring-projects/spring-boot/tree/master/spring-boot-autoconfigure/src/main/java/org/springframework/boot/autoconfigure/jdbc/DataSourceProperties.java)。同时注意你可以通过spring.datasource.*配置任何DataSource实现相关的特定属性：具体参考你使用的连接池实现的文档。

**注**：既然Spring Boot能够从大多数数据库的url上推断出driver-class-name，那么你就不需要再指定它了。对于一个将要创建的DataSource连接池，我们需要能够验证Driver是否可用，所以我们会在做任何事情之前检查它。比如，如果你设置spring.datasource.driverClassName=com.mysql.jdbc.Driver，然后这个类就会被加载。
